; Diagnostic ROM part 8
; Test 8 EEPROM2
; 
; Author Dwight Elvey
;
; Converted to standard assembler Hans Otten, 2025
;
; Standard Defines KIM-1
;
; I/O in 6530-002
;
SAD     =     $1740             ; 6530 A DATA
PADD    =     $1741             ; 6530 A DATA DIRECTION
SBD     =     $1742             ; 6530 B DATA
PBDD    =     $1743             ; 6530 B DATA DIRECTION
CLK1T   =     $1744             ; DIV BY 1 TIME
CLK8T   =     $1745             ; DIV BY 8 TIME
CLK64T  =     $1746             ; DIV BY 64 TIME
CLKKT   =     $1747             ; DIV BY 1024 TIME
CLKRDI  =     $1747             ; READ TIME OUT BIT
CLKRDT  =     $1746             ; READ TIME
;
;
; I/O in 6530-002
;
SAD1     =     $1700             ; 6530 A DATA
PADD1    =     $1701             ; 6530 A DATA DIRECTION
SBD1     =     $1702             ; 6530 B DATA
PBDD1    =     $1703             ; 6530 B DATA DIRECTION
CLK1T1   =     $1704             ; DIV BY 1 TIME
CLK8T1   =     $1705             ; DIV BY 8 TIME
CLK64T1  =     $1706             ; DIV BY 64 TIME
CLKKT1   =     $1707             ; DIV BY 1024 TIME
CLKRDI1  =     $1707             ; READ TIME OUT BIT
CLKRDT1  =     $1706             ; READ TIME

; Zero page 6530--002
;
;
TEMP	= 	  $F8
INH     =     $F9               ; INPUT BUFFER
POINTL  =     $FA               ; LSB OF OPEN CELL
POINTH  =     $FB               ; MSB OF OPEN CELL
CNT		=	  $FC				; counter
;
; KIM-1 Routines
;
SCANDS  = $1F1F
KEYIN   = $1F40
GETKEY  = $1F6A

; Test 8 EEPROM2
;   DB on
;   --
;   S0 on
;   S1 off
;   S2 on
;   S3 off
; This is not really a test. This is code to program the EEPROM on
; the -003 adapter module. The EEPROM on the adapter is not programmed.
; this must be done on the KIM-1 by this program.
; Install the adapter observing the proper orientation with the KIM
; powered off.
; The yellow jumper is part of the decode for -003. The yellow jumper
; must be cut for -003 location. The red jumper enables programming.
; Set the switches as above and hit the RS button then power up. 
; This loads the programming code into RAM. Make sure to
; do a clean reset (RS) after setting up the switches for this code.
; The programming code is loaded into RAM in a millisecond or so. The
; only indication is that the RED LED will be lit.
; The image for the EEPROM is a full 1024 bytes and the diagnosic code
; window in memory is only 1024 bytes. It is not possible to have the
; programming code and the ROM image in the same debug switch settings.
; Once the code is in RAM, it waits for you to select the ROM image
; by the debug switch settings.
; You do this by changing the Debug switches to:
;   DB on
;   --
;   S0 off
;   S1 off
;   S2 on
;   S3 off
; Make sure the upper left keyboard switch is in the off position.
; Now press the ST button. This causes a NMI interrupt that starts
; the programming cycle.
; The green light should flash quickly. This indicated that the programming
; is continuing OK.
; If the Green LED then goes off, the programming is complete.
; If the Green LED comes on steady, the programming has failed.
; It would be wise to test that the EEPROM is working.
; You might run CRC3, Test 5 to verify or check the values
; through the KIM-1 monitor.
; It is wise to now cut the red wire loop at the end of the adapter board.
; This blocks the accidental writes to the EEPROM. I recommend leaving
; a little wire as you might want to change the programming at some
; future time.
; -003 EEPROM code has a large blank portion of code space near the
; end. You might want to want some special code that is always resident
; that you could put it this space. It is starting at 1A96 and ending
; at 1BF9. This is 356 bytes for a small perminent piece of code.
; Of course any change to the -003 EEPROM will also change the CRC3
; results. It is wise to write it down to ensure it you still have
; a -003 valid test.
; 

	.ORG $0C00
	
RESET
          CLD
          LDX #$FF
          TXS
          LDY #$BC
L2006     LDA $0C3F,Y		; copy resident code to zeropage
          STA $003F,Y
          DEY
          BNE L2006
          LDA #$00
          STA $06
          STA $07
          JMP $00F9			; continue in zeropage

          LDX #$00
          STX $0A
          STX $0B
          LDX #$04
          LDY #$00
L2022     CLC
          LDA $0A
          ADC ($0C),Y
          STA $0A
          BCC L202D
          INC $0B
L202D     INY
          BNE L2022
          INC $0D
          DEX
          JMP $0C33
          BRK
          BRK
          BRK
          BRK
          BRK
          BRK
          BRK
          BRK
          BRK
          BRK
		  
; code moved to zeropage to execute when ROM is ammped in by user		  
		  
          LDA #$01		; light status LED
          STA $1000
          JMP $0040
;		
; set EEPROM to programming
;  
          LDX #$00
L204A     CMP ($06),Y
          CMP ($06),Y
          CMP ($06),Y
          CMP ($06),Y
          CMP ($06),Y
          CMP ($06),Y
          CMP ($06),Y
          CMP ($06),Y
          CMP ($06),Y
          CMP ($06),Y
          CMP ($06),Y
          CMP ($06),Y
          CMP ($06),Y
          CMP ($06),Y
          DEX
          NOP
          NOP
          CMP ($01),Y
          BNE L204A
          RTS
;		  
          LDA #$55
          STA $1D73
          LDA #$AA
          STA $1E8C
          LDA #$10
          STA $1D73
          LDA #$55
          STA $1D73
          LDA #$AA
          STA $1E8C
          LDA #$04
          STA $1D73
          LDX #$00
L208E     DEX
          BNE L208E
          LDA #$00
          STA $03		; address of ROM
          STA $01
          LDA #$0C
          STA $04
          LDA #$1C
          STA $02
          LDA #$04
          STA $05
          STA $00
          LDY #$00
L20A7     TYA
          AND #$2F
          BNE L20B5
          LDA $00
          EOR #$FF
          STA $1000
          STA $00
L20B5     LDA ($03),Y		; copy ROM bytes to EEPROM
          STA ($01),Y
          LDX #$00
          JSR $0048
          LDX #$28
L20C0     DEX
          BNE L20C0
          INY
          BNE L20A7
          INC $04
          INC $02
          DEC $05
          BNE L20A7
          LDX #$1C
          STX $08
          STX $09
          LDX #$FA
          STX $01
          LDX #$1F
          STX $02
          LDY #$00
L20DE     LDA $0008,Y
          STA ($01),Y
          JSR $0048
          LDX #$28
L20E8     DEX
          BNE L20E8
          INY
          TYA
          CMP #$02
          BNE L20DE
          LDA #$1C			; status LED
          STA $1000
          JMP $00F6
          JMP $00F9

HEREV
		.FILL (VECTOR - HEREV)&$FFF, 0
		  .ORG $FFFA
VECTOR		  

;
; Reset vectors
;	

          .BYTE $6E
          .BYTE $00
          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256
		 .END